;; Regression test GAMMA-RANDIST for GSLL, automatically generated
;;
;; Copyright 2009 Liam M. Healy
;; Distributed under the terms of the GNU General Public License
;;
;; This program is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or
;; (at your option) any later version.
;;
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with this program.  If not, see <http://www.gnu.org/licenses/>.

(in-package :gsl)

(LISP-UNIT:DEFINE-TEST GAMMA-RANDIST
  (LISP-UNIT::ASSERT-NUMERICAL-EQUAL
   (LIST
    (LIST 3.012983063768798d0 2.216796987787054d0
	  5.033971231985026d0 0.6152002566487763d0
	  0.1876159751197978d0 1.7884608326846099d0
	  0.30812625873110316d0 1.1328459017528132d0
	  0.7363931539298727d0 0.9843618987581162d0
	  0.06871686155296197d0))
   (MULTIPLE-VALUE-LIST
    (LET ((RNG (MAKE-RANDOM-NUMBER-GENERATOR +MT19937+ 0)))
      (LOOP FOR I FROM 0 TO 10 COLLECT
	   (sample rng :gamma :a 1.0d0 :b 2.0d0)))))
  (LISP-UNIT::ASSERT-NUMERICAL-EQUAL
   (LIST
    (LIST 3.012983063768798d0 2.216796987787054d0
	  5.033971231985026d0 0.6152002566487763d0
	  0.1876159751197978d0 1.7884608326846099d0
	  0.30812625873110316d0 1.1328459017528132d0
	  0.7363931539298727d0 0.9843618987581162d0
	  0.06871686155296197d0))
   (MULTIPLE-VALUE-LIST
    (LET ((RNG (MAKE-RANDOM-NUMBER-GENERATOR +MT19937+ 0)))
      (LOOP FOR I FROM 0 TO 10 COLLECT
	   (sample rng :gamma-mt :a 1.0d0 :b 2.0d0)))))
  (LISP-UNIT::ASSERT-NUMERICAL-EQUAL
   (LIST 0.475614712250357d0)
   (MULTIPLE-VALUE-LIST (GAMMA-PDF 0.1d0 1.0d0 2.0d0)))
  ;; Automatically converted from cdf/test.c
  (ASSERT-TO-TOLERANCE (GAMMA-P 0.0d0 1.0d0 1.0d0) 0.0d0 +DBL-EPSILON+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 1.d-100 1.0d0 1.0d0) 1.d-100 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 0.001d0 1.0d0 1.0d0) 9.995001666250082d-4 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 0.01d0 1.0d0 1.0d0) 0.009950166250831947d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 0.1d0 1.0d0 1.0d0) 0.09516258196404043d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 0.325d0 1.0d0 1.0d0) 0.2774726463579278d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 1.0d0 1.0d0 1.0d0) 0.6321205588285577d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 1.5d0 1.0d0 1.0d0) 0.7768698398515702d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 2.0d0 1.0d0 1.0d0) 0.8646647167633873d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 10.0d0 1.0d0 1.0d0) 0.9999546000702375d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 20.0d0 1.0d0 1.0d0) 0.9999999979388464d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 100.0d0 1.0d0 1.0d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 1000.0d0 1.0d0 1.0d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 10000.0d0 1.0d0 1.0d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 0.0d0 1.0d0 1.0d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 1.d-100 1.0d0 1.0d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 0.001d0 1.0d0 1.0d0) 0.999000499833375d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 0.01d0 1.0d0 1.0d0) 0.9900498337491681d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 0.1d0 1.0d0 1.0d0) 0.9048374180359595d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 0.325d0 1.0d0 1.0d0) 0.7225273536420722d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 1.0d0 1.0d0 1.0d0) 0.36787944117144233d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 1.5d0 1.0d0 1.0d0) 0.22313016014842982d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 2.0d0 1.0d0 1.0d0) 0.1353352832366127d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 10.0d0 1.0d0 1.0d0) 4.5399929762484854d-5 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 20.0d0 1.0d0 1.0d0) 2.061153622438558d-9 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 100.0d0 1.0d0 1.0d0) 3.720075976020836d-44 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 1000.0d0 1.0d0 1.0d0) 0.0d0 +DBL-EPSILON+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 10000.0d0 1.0d0 1.0d0) 0.0d0 +DBL-EPSILON+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 0.0d0 1.0d0 10.0d0) 0.0d0 +DBL-EPSILON+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 1.d-100 1.0d0 10.0d0) 1.d-101 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 0.001d0 1.0d0 10.0d0) 9.99950001666625d-5 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 0.01d0 1.0d0 10.0d0) 9.995001666250082d-4 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 0.1d0 1.0d0 10.0d0) 0.009950166250831947d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 0.325d0 1.0d0 10.0d0) 0.031977550168693955d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 1.0d0 1.0d0 10.0d0) 0.09516258196404043d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 1.5d0 1.0d0 10.0d0) 0.1392920235749422d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 2.0d0 1.0d0 10.0d0) 0.18126924692201815d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 10.0d0 1.0d0 10.0d0) 0.6321205588285577d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 20.0d0 1.0d0 10.0d0) 0.8646647167633873d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 100.0d0 1.0d0 10.0d0) 0.9999546000702375d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 1000.0d0 1.0d0 10.0d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 10000.0d0 1.0d0 10.0d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 0.0d0 1.0d0 10.0d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 1.d-100 1.0d0 10.0d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 0.001d0 1.0d0 10.0d0) 0.9999000049998333d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 0.01d0 1.0d0 10.0d0) 0.999000499833375d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 0.1d0 1.0d0 10.0d0) 0.9900498337491681d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 0.325d0 1.0d0 10.0d0) 0.968022449831306d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 1.0d0 1.0d0 10.0d0) 0.9048374180359595d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 1.5d0 1.0d0 10.0d0) 0.8607079764250578d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 2.0d0 1.0d0 10.0d0) 0.8187307530779818d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 10.0d0 1.0d0 10.0d0) 0.36787944117144233d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 20.0d0 1.0d0 10.0d0) 0.1353352832366127d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 100.0d0 1.0d0 10.0d0) 4.5399929762484854d-5 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 1000.0d0 1.0d0 10.0d0) 3.720075976020836d-44 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 10000.0d0 1.0d0 10.0d0) 0.0d0 +DBL-EPSILON+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 0.0d0 17.0d0 10.0d0) 0.0d0 +DBL-EPSILON+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 1.d-100 17.0d0 10.0d0) 0.0d0 +DBL-EPSILON+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 0.001d0 17.0d0 10.0d0) 2.8111917404042285d-83 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 0.01d0 17.0d0 10.0d0) 2.808803246519859d-66 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 0.1d0 17.0d0 10.0d0) 2.7850299808749213d-49 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 0.325d0 17.0d0 10.0d0) 1.3728365324512585d-40 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 1.0d0 17.0d0 10.0d0) 2.5581193229254426d-32 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 1.5d0 17.0d0 10.0d0) 2.4042044117542236d-29 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 2.0d0 17.0d0 10.0d0) 3.0509292621789857d-27 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 10.0d0 17.0d0 10.0d0) 1.094920130378183d-15 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 20.0d0 17.0d0 10.0d0) 5.606050961731617d-11 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 100.0d0 17.0d0 10.0d0) 0.027041609784801128d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 1000.0d0 17.0d0 10.0d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 10000.0d0 17.0d0 10.0d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 0.0d0 17.0d0 10.0d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 1.d-100 17.0d0 10.0d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 0.001d0 17.0d0 10.0d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 0.01d0 17.0d0 10.0d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 0.1d0 17.0d0 10.0d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 0.325d0 17.0d0 10.0d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 1.0d0 17.0d0 10.0d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 1.5d0 17.0d0 10.0d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 2.0d0 17.0d0 10.0d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 10.0d0 17.0d0 10.0d0) 0.9999999999999989d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 20.0d0 17.0d0 10.0d0) 0.9999999999439395d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 100.0d0 17.0d0 10.0d0) 0.9729583902151989d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 1000.0d0 17.0d0 10.0d0) 2.112009516339486d-25 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 10000.0d0 17.0d0 10.0d0) 0.0d0 +DBL-EPSILON+)
  (ASSERT-TO-TOLERANCE (GAMMA-PINV 0.0d0 1.0d0 1.0d0) 0.0d0 +DBL-EPSILON+)
  (ASSERT-TO-TOLERANCE (GAMMA-PINV 1.d-100 1.0d0 1.0d0) 1.d-100 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-PINV 9.995001666250082d-4 1.0d0 1.0d0) 0.001d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-PINV 0.009950166250831947d0 1.0d0 1.0d0) 0.01d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-PINV 0.09516258196404043d0 1.0d0 1.0d0) 0.1d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-PINV 0.2774726463579278d0 1.0d0 1.0d0) 0.325d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-PINV 0.6321205588285577d0 1.0d0 1.0d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-PINV 0.7768698398515702d0 1.0d0 1.0d0) 1.5d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-PINV 0.8646647167633873d0 1.0d0 1.0d0) 2.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-PINV 0.9999546000702375d0 1.0d0 1.0d0) 10.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-PINV 0.9999999979388464d0 1.0d0 1.0d0) 20.0d0 (* 100 +TEST-TOL6+))
  (ASSERT-posinf (GAMMA-PINV 1.0d0 1.0d0 1.0d0))
  (ASSERT-TO-TOLERANCE (GAMMA-PINV 0.1d0 11.887411491530846D0 1.0D0) 7.73788447848618d0 +TEST-TOL1+)
  (ASSERT-posinf (GAMMA-QINV 0.0d0 1.0d0 1.0d0))
  (ASSERT-TO-TOLERANCE (GAMMA-QINV 2.061153622438558d-9 1.0d0 1.0d0) 20.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-QINV 4.5399929762484854d-5 1.0d0 1.0d0) 10.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-QINV 0.1353352832366127d0 1.0d0 1.0d0) 2.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-QINV 0.22313016014842982d0 1.0d0 1.0d0) 1.5d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-QINV 0.36787944117144233d0 1.0d0 1.0d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-QINV 0.7225273536420722d0 1.0d0 1.0d0) 0.325d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-QINV 0.9048374180359595d0 1.0d0 1.0d0) 0.1d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-QINV 0.9900498337491681d0 1.0d0 1.0d0) 0.01d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-QINV 0.999000499833375d0 1.0d0 1.0d0) 0.001d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-QINV 1.0d0 1.0d0 1.0d0) 0.0d0 +DBL-EPSILON+)
  ;; Automatically converted from cdf/test_auto.c
  (ASSERT-TO-TOLERANCE (GAMMA-P 0.0d0 1.3d0 2.7d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 1.d-10 1.3d0 2.7d0) 2.356478475164d-14 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-PINV 2.356478475163866d-14 1.3d0 2.7d0) 1.d-10 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 1.d-9 1.3d0 2.7d0) 4.701792696644d-13 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-PINV 4.701792696643945d-13 1.3d0 2.7d0) 1.d-9 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 1.d-8 1.3d0 2.7d0) 9.381309762735d-12 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-PINV 9.381309762734639d-12 1.3d0 2.7d0) 1.d-8 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 1.d-7 1.3d0 2.7d0) 1.871817348197d-10 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-PINV 1.8718173481972823d-10 1.3d0 2.7d0) 1.d-7 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 1.d-6 1.3d0 2.7d0) 3.734765911711d-9 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-PINV 3.734765911711424d-9 1.3d0 2.7d0) 1.d-6 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 1.d-5 1.3d0 2.7d0) 7.451823639191d-8 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-PINV 7.451823639191012d-8 1.3d0 2.7d0) 1.d-5 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 1.d-4 1.3d0 2.7d0) 1.486806276026d-6 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-PINV 1.4868062760263472d-6 1.3d0 2.7d0) 1.d-4 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 0.001d0 1.3d0 2.7d0) 2.966009681152d-5 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-PINV 2.9660096811518665d-5 1.3d0 2.7d0) 0.001d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 0.01d0 1.3d0 2.7d0) 5.90683103295d-4 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-PINV 5.906831032949983d-4 1.3d0 2.7d0) 0.01d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 0.1d0 1.3d0 2.7d0) 0.01156629233128d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-PINV 0.011566292331279586d0 1.3d0 2.7d0) 0.1d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 1.0d0 1.3d0 2.7d0) 0.1921237769663d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-PINV 0.19212377696630473d0 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 10.0d0 1.3d0 2.7d0) 0.9565035356115d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-PINV 0.9565035356115379d0 1.3d0 2.7d0) 10.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 100.0d0 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 1000.0d0 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 10000.0d0 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 100000.0d0 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 1000000.0d0 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 1.d7 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 1.d8 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 1.d9 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 1.d10 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 1.d10 1.3d0 2.7d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 1.d9 1.3d0 2.7d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 1.d8 1.3d0 2.7d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 1.d7 1.3d0 2.7d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 1000000.0d0 1.3d0 2.7d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 100000.0d0 1.3d0 2.7d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 10000.0d0 1.3d0 2.7d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 1000.0d0 1.3d0 2.7d0) 9.292091038794d-161 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-QINV 9.292091038793986d-161 1.3d0 2.7d0) 1000.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 100.0d0 1.3d0 2.7d0) 2.729167976527d-16 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-QINV 2.7291679765273174d-16 1.3d0 2.7d0) 100.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 10.0d0 1.3d0 2.7d0) 0.04349646438846d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-QINV 0.04349646438846219d0 1.3d0 2.7d0) 10.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 1.0d0 1.3d0 2.7d0) 0.8078762230337d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-QINV 0.8078762230336953d0 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 0.1d0 1.3d0 2.7d0) 0.9884337076687d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-QINV 0.9884337076687204d0 1.3d0 2.7d0) 0.1d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 0.01d0 1.3d0 2.7d0) 0.9994093168967d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-QINV 0.999409316896705d0 1.3d0 2.7d0) 0.01d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 0.001d0 1.3d0 2.7d0) 0.9999703399032d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 1.d-4 1.3d0 2.7d0) 0.9999985131937d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 1.d-5 1.3d0 2.7d0) 0.9999999254818d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 1.d-6 1.3d0 2.7d0) 0.9999999962652d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 1.d-7 1.3d0 2.7d0) 0.9999999998128d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 1.d-8 1.3d0 2.7d0) 0.9999999999906d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 1.d-9 1.3d0 2.7d0) 0.9999999999995d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 1.d-10 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 0.0d0 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  ;; Automatically converted from cdf/test_auto.c
  (ASSERT-TO-TOLERANCE (GAMMA-P 0.0d0 1.3d0 123.0d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 1.d-10 1.3d0 123.0d0) 1.644976604681d-16 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-PINV 1.6449766046812008d-16 1.3d0 123.0d0) 1.d-10 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 1.d-9 1.3d0 123.0d0) 3.282159828312d-15 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-PINV 3.2821598283122862d-15 1.3d0 123.0d0) 1.d-9 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 1.d-8 1.3d0 123.0d0) 6.548769816865d-14 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-PINV 6.548769816865393d-14 1.3d0 123.0d0) 1.d-8 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 1.d-7 1.3d0 123.0d0) 1.306651361959d-12 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-PINV 1.3066513619593202d-12 1.3d0 123.0d0) 1.d-7 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 1.d-6 1.3d0 123.0d0) 2.607112210538d-11 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-PINV 2.6071122105378624d-11 1.3d0 123.0d0) 1.d-6 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 1.d-5 1.3d0 123.0d0) 5.201872529446d-10 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-PINV 5.201872529445639d-10 1.3d0 123.0d0) 1.d-5 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 1.d-4 1.3d0 123.0d0) 1.037909593275d-8 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-PINV 1.037909593275298d-8 1.3d0 123.0d0) 1.d-4 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 0.001d0 1.3d0 123.0d0) 2.070893333124d-7 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-PINV 2.0708933331240137d-7 1.3d0 123.0d0) 0.001d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 0.01d0 1.3d0 123.0d0) 4.131804542806d-6 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-PINV 4.131804542806129d-6 1.3d0 123.0d0) 0.01d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 0.1d0 1.3d0 123.0d0) 8.240625287202d-5 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-PINV 8.240625287201719d-5 1.3d0 123.0d0) 0.1d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 1.0d0 1.3d0 123.0d0) 0.001637438876041d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-PINV 0.0016374388760411608d0 1.3d0 123.0d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 10.0d0 1.3d0 123.0d0) 0.03135521671622d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-PINV 0.03135521671622352d0 1.3d0 123.0d0) 10.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 100.0d0 1.3d0 123.0d0) 0.4240385705334d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-PINV 0.42403857053338523d0 1.3d0 123.0d0) 100.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 1000.0d0 1.3d0 123.0d0) 0.9993635318324d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-PINV 0.9993635318323562d0 1.3d0 123.0d0) 1000.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 10000.0d0 1.3d0 123.0d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 100000.0d0 1.3d0 123.0d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 1000000.0d0 1.3d0 123.0d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 1.d7 1.3d0 123.0d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 1.d8 1.3d0 123.0d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 1.d9 1.3d0 123.0d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-P 1.d10 1.3d0 123.0d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 1.d10 1.3d0 123.0d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 1.d9 1.3d0 123.0d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 1.d8 1.3d0 123.0d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 1.d7 1.3d0 123.0d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 1000000.0d0 1.3d0 123.0d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 100000.0d0 1.3d0 123.0d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 10000.0d0 1.3d0 123.0d0) 2.056363344745d-35 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-QINV 2.0563633447452943d-35 1.3d0 123.0d0) 10000.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 1000.0d0 1.3d0 123.0d0) 6.36468167644d-4 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-QINV 6.364681676439553d-4 1.3d0 123.0d0) 1000.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 100.0d0 1.3d0 123.0d0) 0.5759614294666d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-QINV 0.5759614294666149d0 1.3d0 123.0d0) 100.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 10.0d0 1.3d0 123.0d0) 0.9686447832838d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-QINV 0.9686447832837765d0 1.3d0 123.0d0) 10.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 1.0d0 1.3d0 123.0d0) 0.998362561124d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-QINV 0.9983625611239588d0 1.3d0 123.0d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 0.1d0 1.3d0 123.0d0) 0.9999175937471d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-QINV 0.999917593747128d0 1.3d0 123.0d0) 0.1d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 0.01d0 1.3d0 123.0d0) 0.9999958681955d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 0.001d0 1.3d0 123.0d0) 0.9999997929107d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 1.d-4 1.3d0 123.0d0) 0.9999999896209d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 1.d-5 1.3d0 123.0d0) 0.9999999994798d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 1.d-6 1.3d0 123.0d0) 0.9999999999739d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 1.d-7 1.3d0 123.0d0) 0.9999999999987d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 1.d-8 1.3d0 123.0d0) 0.9999999999999d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 1.d-9 1.3d0 123.0d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 1.d-10 1.3d0 123.0d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GAMMA-Q 0.0d0 1.3d0 123.0d0) 1.0d0 +TEST-TOL6+))
