;; Regression test GUMBEL2 for GSLL, automatically generated
;;
;; Copyright 2009 Liam M. Healy
;; Distributed under the terms of the GNU General Public License
;;
;; This program is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or
;; (at your option) any later version.
;;
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with this program.  If not, see <http://www.gnu.org/licenses/>.

(in-package :gsl)

(LISP-UNIT:DEFINE-TEST GUMBEL2
  (LISP-UNIT::ASSERT-NUMERICAL-EQUAL
   (LIST
    (LIST 7743.400858519516d0 1.102196701680339d0
	  1.5827044520998628d0 36.87052393317972d0
	  1.3675219066608615d0 2.7637257945633085d0
	  46.026080060263446d0 6.772683525074477d0
	  3.2461983686562204d0 6.640797807286079d0
	  7.285687897019733d0))
   (MULTIPLE-VALUE-LIST
    (LET ((RNG (MAKE-RANDOM-NUMBER-GENERATOR +MT19937+ 0)))
      (LOOP FOR I FROM 0 TO 10 COLLECT
	   (sample rng :gumbel2 :a 1.0d0 :b 2.0d0)))))
  (LISP-UNIT::ASSERT-NUMERICAL-EQUAL
   (LIST 0.053625603682851145d0)
   (MULTIPLE-VALUE-LIST (GUMBEL2-PDF 5.0d0 1.0d0 2.0d0)))
  ;; Automatically converted from cdf/test_auto.c
  (ASSERT-TO-TOLERANCE (GUMBEL2-P 0.0d0 1.3d0 2.7d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL2-P 1.d-10 1.3d0 2.7d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL2-P 1.d-9 1.3d0 2.7d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL2-P 1.d-8 1.3d0 2.7d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL2-P 1.d-7 1.3d0 2.7d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL2-P 1.d-6 1.3d0 2.7d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL2-P 1.d-5 1.3d0 2.7d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL2-P 1.d-4 1.3d0 2.7d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL2-P 0.001d0 1.3d0 2.7d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL2-P 0.01d0 1.3d0 2.7d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL2-P 0.1d0 1.3d0 2.7d0) 4.014688368993d-24 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL2-PINV 4.0146883689934746d-24 1.3d0 2.7d0) 0.1d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL2-P 1.0d0 1.3d0 2.7d0) 0.06720551273975d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL2-PINV 0.06720551273974974d0 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL2-P 10.0d0 1.3d0 2.7d0) 0.8734358842463d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL2-PINV 0.8734358842462814d0 1.3d0 2.7d0) 10.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL2-P 100.0d0 1.3d0 2.7d0) 0.9932408531257d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL2-PINV 0.9932408531257445d0 1.3d0 2.7d0) 100.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL2-P 1000.0d0 1.3d0 2.7d0) 0.9996601479016d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL2-PINV 0.9996601479016278d0 1.3d0 2.7d0) 1000.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL2-P 10000.0d0 1.3d0 2.7d0) 0.9999829642968d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL2-P 100000.0d0 1.3d0 2.7d0) 0.9999991461854d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL2-P 1000000.0d0 1.3d0 2.7d0) 0.9999999572079d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL2-P 1.d7 1.3d0 2.7d0) 0.9999999978553d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL2-P 1.d8 1.3d0 2.7d0) 0.9999999998925d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL2-P 1.d9 1.3d0 2.7d0) 0.9999999999946d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL2-P 1.d10 1.3d0 2.7d0) 0.9999999999997d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL2-Q 1.d10 1.3d0 2.7d0) 2.7d-13 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL2-QINV 2.699999999999649d-13 1.3d0 2.7d0) 1.d10 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL2-Q 1.d9 1.3d0 2.7d0) 5.387208250401d-12 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL2-QINV 5.387208250401491d-12 1.3d0 2.7d0) 1.d9 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL2-Q 1.d8 1.3d0 2.7d0) 1.074889360437d-10 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL2-QINV 1.0748893604366781d-10 1.3d0 2.7d0) 1.d8 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL2-Q 1.d7 1.3d0 2.7d0) 2.144686231456d-9 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL2-QINV 2.1446862314557286d-9 1.3d0 2.7d0) 1.d7 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL2-Q 1000000.0d0 1.3d0 2.7d0) 4.279211528087d-8 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL2-QINV 4.2792115280867646d-8 1.3d0 2.7d0) 1000000.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL2-Q 100000.0d0 1.3d0 2.7d0) 8.538146037456d-7 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL2-QINV 8.53814603745569d-7 1.3d0 2.7d0) 100000.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL2-Q 10000.0d0 1.3d0 2.7d0) 1.703570319173d-5 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL2-QINV 1.7035703191725618d-5 1.3d0 2.7d0) 10000.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL2-Q 1000.0d0 1.3d0 2.7d0) 3.398520983725d-4 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL2-QINV 3.398520983724625d-4 1.3d0 2.7d0) 1000.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL2-Q 100.0d0 1.3d0 2.7d0) 0.006759146874256d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL2-QINV 0.0067591468742558315d0 1.3d0 2.7d0) 100.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL2-Q 10.0d0 1.3d0 2.7d0) 0.1265641157537d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL2-QINV 0.12656411575371904d0 1.3d0 2.7d0) 10.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL2-Q 1.0d0 1.3d0 2.7d0) 0.9327944872603d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL2-QINV 0.9327944872602512d0 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL2-Q 0.1d0 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL2-Q 0.01d0 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL2-Q 0.001d0 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL2-Q 1.d-4 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL2-Q 1.d-5 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL2-Q 1.d-6 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL2-Q 1.d-7 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL2-Q 1.d-8 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL2-Q 1.d-9 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL2-Q 1.d-10 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL2-Q 0.0d0 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+))
