;; Regression test HANKEL for GSLL, automatically generated
;;
;; Copyright 2009, 2014 Liam M. Healy
;; Distributed under the terms of the GNU General Public License
;;
;; This program is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or
;; (at your option) any later version.
;;
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with this program.  If not, see <http://www.gnu.org/licenses/>.

(in-package :gsl)

(LISP-UNIT:DEFINE-TEST HANKEL
  (LISP-UNIT::ASSERT-NUMERICAL-EQUAL
   (LIST
    #(0.3752546494075203d0 -0.13350787269556064d0
      0.0446799251438404d0))
   (MULTIPLE-VALUE-LIST
    (grid:copy-to
     (APPLY-HANKEL (MAKE-HANKEL 3 1.0d0 1.0d0)
		   (GRID:MAKE-FOREIGN-ARRAY 'DOUBLE-FLOAT
					    :INITIAL-CONTENTS
					    '(1.0d0 2.0d0 3.0d0)))
     'array 'double-float)))
  (LISP-UNIT::ASSERT-NUMERICAL-EQUAL
   (LIST
    #(1.000011918676266d0 1.9999790476647115d0
      3.000035803234508d0))
   (MULTIPLE-VALUE-LIST
    (LET ((HANK (MAKE-HANKEL 3 1.0d0 1.0d0)))
      (grid:copy-to
       (ELT* (EXPT (BESSEL-ZERO-J1 4) 2)
	     (APPLY-HANKEL HANK
			   (APPLY-HANKEL HANK
					 (GRID:MAKE-FOREIGN-ARRAY
					  'DOUBLE-FLOAT
					  :INITIAL-CONTENTS
					  '(1.0d0 2.0d0
					    3.0d0)))))
       'array 'double-float))))
  (LISP-UNIT::ASSERT-NUMERICAL-EQUAL
   (LIST
    #(3.999613382195876d0 2.9590494996797356d0
      2.5988153931742644d0 2.244949914340878d0
      2.0471887989290325d0 1.8387637474026606d0
      1.7038116067850126d0 1.558629447822686d0
      1.457465886742508d0 1.3477077353184197d0
      1.2677885358829588d0 1.180705757895959d0
      1.1154275575193124d0 1.0441104026945338d0
      0.9895502829249535d0 0.9298267109187849d0
      0.8834540329688342d0 0.8326071421876684d0
      0.7926887339130819d0 0.7488473884170335d0
      0.7141410718481743d0 0.6759599039143386d0
      0.645543125826266d0 0.6120212313620069d0
      0.585188941532653d0 0.5555608216697704d0
      0.5317614289453996d0 0.5054281329701265d0
      0.4842216209014168d0 0.46070549373999364d0
      0.44173504981588874d0 0.42064897189921246d0
      0.4036211883401533d0 0.3846470554547713d0
      0.36931775239476394d0 0.3521910403797792d0
      0.3383548854495752d0 0.32285333596747223d0
      0.31033609304085563d0 0.29627125986138264d0
      0.2849238996817142d0 0.2721347240915549d0
      0.2618288798053955d0 0.25017673349701747d0
      0.24080114503840122d0 0.23016595284609306d0
      0.22162365006906917d0 0.21190081982719952d0
      0.20410686556317653d0 0.19520482984534177d0
      0.18808449295240168d0 0.17992272069852366d0
      0.17340998329964555d0 0.16591735656765613d0
      0.15995368388575928d0 0.15306716140719054d0
      0.14760048003406076d0 0.14126398830716866d0
      0.13624783146109629d0 0.1304113380291683d0
      0.1258041257526665d0 0.12042285960113851d0
      0.11618728887335918d0 0.11122108057034805d0
      0.1073236056149206d0 0.1027363256315913d0
      0.09914671274959008d0 0.09490579083210804d0
      0.09159673520860905d0 0.08767274708961817d0
      0.08461954144555214d0 0.08098585183714455d0
      0.07816609869653629d0 0.07479855158537972d0
      0.07219191242674522d0 0.06906856133255501d0
      0.06665653708497662d0 0.06375740924756308d0
      0.06152314754614929d0 0.05883003704989449d0
      0.056758162434269836d0 0.0542544481194796d0
      0.05233091198237958d0 0.05000139667409954d0
      0.04821334427556784d0 0.04604411241559909d0
      0.044379764695173934d0 0.04235805591794931d0
      0.040806604180850053d0 0.03892070074853845d0
      0.03747221258651291d0 0.03571133890891594d0
      0.034356673953307534d0 0.032710906676063356d0
      0.03144164097868383d0 0.029901828338797454d0
      0.02871018634247016d0 0.027267875670950514d0
      0.026146668871714095d0 0.024794041275393204d0
      0.02373661279695407d0 0.022466424180279245d0
      0.0214665985820008d0 0.02027212627887299d0
      0.019324164004417672d0 0.01819915838319535d0
      0.01729771433029796d0 0.01623635481455548d0
      0.015376440569343904d0 0.014373295585145955d0
      0.013550244918538984d0 0.012600235337534856d0
      0.01180967260792358d0 0.010908038306068443d0
      0.010145849452853337d0 0.009288118648205028d0
      0.008550424495723163d0 0.00773238556658004d0
      0.007015517188341694d0 0.0062331927058194405d0
      0.005533668625405035d0 0.004783291363154884d0
      0.004097796391149235d0 0.0033757870998249047d0
      0.0027011526262948893d0 0.0020040993821861235d0
      0.0013372849617528388d0 6.61923918047693d-4))
   (MULTIPLE-VALUE-LIST
    (LET ((HANK (MAKE-HANKEL 128 0.0d0 100.0d0))
	  (IN (GRID:MAKE-FOREIGN-ARRAY 'DOUBLE-FLOAT :DIMENSIONS 128)))
      (LOOP FOR N FROM 0 BELOW 128 DO
	(SETF (GRID:AREF IN N)
	      (/
	       (1+
		(EXPT (SAMPLE-X-HANKEL HANK N)
		      2)))))
      (grid:copy-to (APPLY-HANKEL HANK IN) 'array 'double-float))))
  (LISP-UNIT::ASSERT-NUMERICAL-EQUAL
   (LIST
    #(0.18148296716239096d0 0.29470565030732726d0
      0.36014071007580134d0 0.38393838323170737d0
      0.3787243832069302d0 0.35680451269699853d0
      0.32719827445314d0 0.29549896085299493d0
      0.2647580198243113d0 0.23641995829602658d0
      0.21101009980456306d0 0.18856930977901765d0
      0.16890677613542032d0 0.1517384130371959d0
      0.1367587824198243d0 0.12367576929148846d0
      0.11222543286943583d0 0.10217644238204905d0
      0.09332957028622187d0 0.08551485860324168d0
      0.07858809137895775d0 0.07242712803768264d0
      0.06692858136542122d0 0.062004821232161916d0
      0.05758146244658014d0 0.053595185276619335d0
      0.04999196384134086d0 0.046725541001666086d0
      0.04375620874198922d0 0.04104975161341935d0
      0.03857661181216136d0 0.03631115516711897d0
      0.03423109802603913d0 0.03231699265897519d0
      0.030551831320115498d0 0.02892068100516861d0
      0.02741040776410905d0 0.026009413816598603d0
      0.024707444059819464d0 0.023495394037512624d0
      0.022365173140791242d0 0.02130956219495465d0
      0.020322116148839647d0 0.01939705684038664d0
      0.018529203464258202d0 0.01771389059665254d0
      0.01694691839107124d0 0.016224488971614784d0
      0.015543170765710684d0 0.014899848424196567d0
      0.014291697367627454d0 0.013716143792157022d0
      0.01317084664870968d0 0.01265366526147142d0
      0.012162646750100842d0 0.01169599946356397d0
      0.011252084408499048d0 0.010829393178252445d0
      0.010426542340894468d0 0.010042254883631278d0
      0.009675356792194723d0 0.00932476127601623d0
      0.00898946697079923d0 0.008668544388266966d0
      0.008361135318857875d0 0.008066441080928962d0
      0.007783722806642836d0 0.007512291162679222d0
      0.007251507280583145d0 0.007000773693720288d0
      0.00675953573139716d0 0.006527273471625468d0
      0.006303503461696351d0 0.006087771528027549d0
      0.005879654718483168d0 0.005678754842563456d0
      0.005484700555421931d0 0.005297141526377206d0
      0.0051157506033316655d0 0.004940218526833847d0
      0.00477025612792835d0 0.004605589520098166d0
      0.004445962294572635d0 0.0042911311344092885d0
      0.004140867979756237d0 0.0039949560178288365d0
      0.0038531917971695822d0 0.0037153815548816643d0
      0.003581343264005873d0 0.0034509032655077846d0
      0.003323898236834706d0 0.003200172101134867d0
      0.003079577908126764d0 0.002961974997096721d0
      0.0028472307836038984d0 0.0027352181561528014d0
      0.002625817164114593d0 0.0025189126307414936d0
      0.0024143957391336945d0 0.0023121618465690775d0
      0.0022121119664674426d0 0.0021141507709408975d0
      0.002018187967575297d0 0.001924136478735778d0
      0.001831913712650709d0 0.0017414399093866597d0
      0.0016526393062286607d0 0.0015654386414163176d0
      0.0014797682141932601d0 0.0013955605384065178d0
      0.0013127512978786322d0 0.0012312781428431572d0
      0.0011510815414937277d0 0.00107210371298205d0
      9.942893761365095d-4 9.175848134081186d-4
      8.419385178359977d-4 7.673003829045368d-4
      6.936222488781405d-4 6.208572140409949d-4
      5.48960081537033d-4 4.778867879152608d-4
      4.0759475159422257d-4 3.380424150383489d-4
      2.6918949593288056d-4 2.0099663967250854d-4
      1.3342557428046146d-4 6.643887021579182d-5))
   (MULTIPLE-VALUE-LIST
    (LET ((HANK (MAKE-HANKEL 128 1.0d0 20.0d0))
	  (IN (GRID:MAKE-FOREIGN-ARRAY 'DOUBLE-FLOAT :DIMENSIONS 128)))
      (LOOP FOR N FROM 0 BELOW 128 DO
	(SETF (GRID:AREF IN N)
	      (EXP (- (SAMPLE-X-HANKEL HANK N)))))
      (grid:copy-to (APPLY-HANKEL HANK IN) 'array 'double-float))))
  (LISP-UNIT::ASSERT-NUMERICAL-EQUAL
   (LIST
    #(0.05727421417071144d0 -0.0069532329565967065d0
      0.0018971857538533253d0 -7.385636709121818d-4
      3.5175873050275684d-4 -1.908501261051786d-4
      1.1343913621280217d-4 -7.213421291301775d-5
      4.831516921458092d-5 -3.3723779917274374d-5
      2.434180086051901d-5 -1.8065284579238698d-5
      1.3724998738624818d-5 -1.0638269899482022d-5
      8.389564299852857d-6 -6.716787851884958d-6
      5.4494583042956006d-6 -4.473659746322425d-6
      3.7114472733338708d-6 -3.1083533128244284d-6
      2.6255924991650015d-6 -2.235074527681444d-6
      1.9161407924824944d-6 -1.653385099988945d-6
      1.4351712079583385d-6 -1.2526072554615887d-6
      1.0988252471988579d-6 -9.684676292750772d-7
      8.57316620474898d-7 -7.620233501489076d-7
      6.799076944952719d-7 -6.088088050506787d-7
      5.469723983029046d-7 -4.929649874879453d-7
      4.456080564252108d-7 -4.0392713194195724d-7
      3.671120842309571d-7 -3.3448595889463247d-7
      3.054803422148767d-7 -2.796157660067292d-7
      2.564860270680612d-7 -2.3574556741320942d-7
      2.170992623929696d-7 -2.002941147715334d-7
      1.8511246557512996d-7 -1.7136641889677343d-7
      1.5889324272974863d-7 -1.4755155904832756d-7
      1.3721817472109516d-7 -1.2778543492318917d-7
      1.1915900476790067d-7 -1.1125600318585208d-7
      1.040034276706828d-7 -9.733682008056086d-8
      9.119913297327704d-8 -8.553976358859125d-8
      8.031372792875388d-8 -7.548095283772776d-8
      7.100566755518077d-8 -6.68558792010963d-8
      6.300291959721013d-8 -5.9421052725079615d-8
      5.6087133950495193d-8 -5.298031333329035d-8
      5.008177685847466d-8 -4.7374520367347216d-8
      4.484315137431377d-8 -4.2473715219018076d-8
      4.025354202578848d-8 -3.817111204572646d-8
      3.6215936597200756d-8 -3.437845290935511d-8
      3.2649930833631756d-8 -3.102239018286913d-8
      2.9488527048637057d-8 -2.8041648538104078d-8
      2.667561410493147d-8 -2.5384783624118998d-8
      2.4163970588120923d-8 -2.300840034238607d-8
      2.1913672633131398d-8 -2.087572793887037d-8
      1.989081705431389d-8 -1.895547394901166d-8
      1.8066491056844387d-8 -1.722089713847141d-8
      1.6415937076515288d-8 -1.564905380812804d-8
      1.4917871753553015d-8 -1.4220181907321714d-8
      1.3553928198634856d-8 -1.2917195186058476d-8
      1.2308196818463852d-8 -1.172526609368855d-8
      1.1166845862602938d-8 -1.0631480105815154d-8
      1.0117806198277814d-8 -9.624547834710752d-9
      9.15050843258525d-9 -8.694564922238638d-9
      8.255662619348403d-9 -7.832809819635316d-9
      7.425073356059465d-9 -7.0315741634142205d-9
      6.651483323358955d-9 -6.284018536026942d-9
      5.928440599955045d-9 -5.58405038119885d-9
      5.250185896182729d-9 -4.926219672439751d-9
      4.6115561380581905d-9 -4.305629398642933d-9
      4.007901159704123d-9 -3.7178586238511365d-9
      3.435012572697998d-9 -3.158895766718875d-9
      2.889061227157417d-9 -2.625080685183769d-9
      2.3665432018319277d-9 -2.113053768635549d-9
      1.8642320884750883d-9 -1.6197112376850537d-9
      1.3791367639672673d-9 -1.142165334893339d-9
      9.084639046107121d-10 -6.777086159631958d-10
      4.4958390074262106d-10 -2.2378156576350344d-10))
   (MULTIPLE-VALUE-LIST
    (LET ((HANK (MAKE-HANKEL 128 1.0d0 1.0d0))
	  (IN (GRID:MAKE-FOREIGN-ARRAY 'DOUBLE-FLOAT :DIMENSIONS 128)))
      (LOOP FOR N FROM 0 BELOW 128 DO
	(SETF (GRID:AREF IN N)
	      (LET ((X (SAMPLE-X-HANKEL HANK N)))
		(* X (- 1 (EXPT X 2))))))
      (grid:copy-to (APPLY-HANKEL HANK IN) 'array 'double-float)))))

