;; Regression test RAYLEIGH for GSLL, automatically generated
;;
;; Copyright 2009 Liam M. Healy
;; Distributed under the terms of the GNU General Public License
;;
;; This program is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or
;; (at your option) any later version.
;;
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with this program.  If not, see <http://www.gnu.org/licenses/>.

(in-package :gsl)

(LISP-UNIT:DEFINE-TEST RAYLEIGH
  (LISP-UNIT::ASSERT-NUMERICAL-EQUAL
   (LIST
    (LIST 0.22728151965522753d0 19.05023959323748d0
	  15.897545756713367d0 3.2937477899992147d0
	  17.102628005168157d0 12.030467929000928d0
	  2.9480035446666624d0 7.6851014424603274d0
	  11.100498132125239d0 7.76103902005281d0
	  7.409599155063027d0))
   (MULTIPLE-VALUE-LIST
    (LET ((RNG (MAKE-RANDOM-NUMBER-GENERATOR +MT19937+ 0)))
      (LOOP FOR I FROM 0 TO 10 COLLECT
	   (sample rng :rayleigh :sigma 10.0d0)))))
  (LISP-UNIT::ASSERT-NUMERICAL-EQUAL
   (LIST 0.4412484512922977d0)
   (MULTIPLE-VALUE-LIST (RAYLEIGH-PDF 0.5d0 1.0d0)))
  ;; Automatically converted from cdf/test_auto.c
  (ASSERT-TO-TOLERANCE (RAYLEIGH-P 0.0d0 1.3d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (RAYLEIGH-P 1.d-10 1.3d0) 2.958579881657d-21 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (RAYLEIGH-PINV 2.958579881656805d-21 1.3d0) 1.d-10 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (RAYLEIGH-P 1.d-9 1.3d0) 2.958579881657d-19 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (RAYLEIGH-PINV 2.958579881656805d-19 1.3d0) 1.d-9 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (RAYLEIGH-P 1.d-8 1.3d0) 2.958579881657d-17 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (RAYLEIGH-PINV 2.958579881656805d-17 1.3d0) 1.d-8 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (RAYLEIGH-P 1.d-7 1.3d0) 2.958579881657d-15 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (RAYLEIGH-PINV 2.9585798816568d-15 1.3d0) 1.d-7 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (RAYLEIGH-P 1.d-6 1.3d0) 2.958579881656d-13 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (RAYLEIGH-PINV 2.9585798816563665d-13 1.3d0) 1.d-6 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (RAYLEIGH-P 1.d-5 1.3d0) 2.958579881613d-11 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (RAYLEIGH-PINV 2.958579881613039d-11 1.3d0) 1.d-5 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (RAYLEIGH-P 1.d-4 1.3d0) 2.95857987728d-9 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (RAYLEIGH-PINV 2.9585798772802076d-9 1.3d0) 1.d-4 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (RAYLEIGH-P 0.001d0 1.3d0) 2.958579443997d-7 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (RAYLEIGH-PINV 2.9585794439971025d-7 1.3d0) 0.001d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (RAYLEIGH-P 0.01d0 1.3d0) 2.958536116114d-5 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (RAYLEIGH-PINV 2.9585361161138382d-5 1.3d0) 0.01d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (RAYLEIGH-P 0.1d0 1.3d0) 0.002954207597179d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (RAYLEIGH-PINV 0.0029542075971792496d0 1.3d0) 0.1d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (RAYLEIGH-P 1.0d0 1.3d0) 0.2561069378624d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (RAYLEIGH-PINV 0.2561069378623536d0 1.3d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (RAYLEIGH-P 10.0d0 1.3d0) 0.9999999999999d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (RAYLEIGH-P 100.0d0 1.3d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (RAYLEIGH-P 1000.0d0 1.3d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (RAYLEIGH-P 10000.0d0 1.3d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (RAYLEIGH-P 100000.0d0 1.3d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (RAYLEIGH-P 1000000.0d0 1.3d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (RAYLEIGH-P 1.d7 1.3d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (RAYLEIGH-P 1.d8 1.3d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (RAYLEIGH-P 1.d9 1.3d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (RAYLEIGH-P 1.d10 1.3d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (RAYLEIGH-Q 1.d10 1.3d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (RAYLEIGH-Q 1.d9 1.3d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (RAYLEIGH-Q 1.d8 1.3d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (RAYLEIGH-Q 1.d7 1.3d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (RAYLEIGH-Q 1000000.0d0 1.3d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (RAYLEIGH-Q 100000.0d0 1.3d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (RAYLEIGH-Q 10000.0d0 1.3d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (RAYLEIGH-Q 1000.0d0 1.3d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (RAYLEIGH-Q 100.0d0 1.3d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (RAYLEIGH-Q 10.0d0 1.3d0) 1.415959498849d-13 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (RAYLEIGH-QINV 1.4159594988487832d-13 1.3d0) 10.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (RAYLEIGH-Q 1.0d0 1.3d0) 0.7438930621376d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (RAYLEIGH-QINV 0.7438930621376464d0 1.3d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (RAYLEIGH-Q 0.1d0 1.3d0) 0.9970457924028d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (RAYLEIGH-QINV 0.9970457924028208d0 1.3d0) 0.1d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (RAYLEIGH-Q 0.01d0 1.3d0) 0.9999704146388d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (RAYLEIGH-Q 0.001d0 1.3d0) 0.9999997041421d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (RAYLEIGH-Q 1.d-4 1.3d0) 0.9999999970414d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (RAYLEIGH-Q 1.d-5 1.3d0) 0.9999999999704d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (RAYLEIGH-Q 1.d-6 1.3d0) 0.9999999999997d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (RAYLEIGH-Q 1.d-7 1.3d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (RAYLEIGH-Q 1.d-8 1.3d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (RAYLEIGH-Q 1.d-9 1.3d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (RAYLEIGH-Q 1.d-10 1.3d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (RAYLEIGH-Q 0.0d0 1.3d0) 1.0d0 +TEST-TOL6+))

