;; Regression test ROOTS-MULTI for GSLL, automatically generated
;;
;; Copyright 2009 Liam M. Healy
;; Distributed under the terms of the GNU General Public License
;;
;; This program is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or
;; (at your option) any later version.
;;
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with this program.  If not, see <http://www.gnu.org/licenses/>.

(in-package :gsl)

(LISP-UNIT:DEFINE-TEST ROOTS-MULTI
  (LISP-UNIT::ASSERT-NUMERICAL-EQUAL
   (LIST 0.9999999999999992d0 0.9999999999999716d0
	 7.771561172376096d-16 -2.686739719592879d-13)
   (MULTIPLE-VALUE-LIST
    (ROOTS-MULTI-EXAMPLE-NO-DERIVATIVE +HYBRID-UNSCALED+ NIL)))
  (LISP-UNIT::ASSERT-NUMERICAL-EQUAL
   (LIST 1.0d0 1.0d0 0.0d0 0.0d0)
   (MULTIPLE-VALUE-LIST
    (ROOTS-MULTI-EXAMPLE-NO-DERIVATIVE +HYBRID-SCALED+ NIL)))
  (LISP-UNIT::ASSERT-NUMERICAL-EQUAL
   (LIST 1.0d0 1.0000000000000004d0 0.0d0
	 4.440892098500626d-15)
   (MULTIPLE-VALUE-LIST
    (ROOTS-MULTI-EXAMPLE-NO-DERIVATIVE +DISCRETE-NEWTON+ NIL)))
  (LISP-UNIT::ASSERT-NUMERICAL-EQUAL
   (LIST 1.0d0 1.0000000000000568d0 0.0d0
	 5.684341886080801d-13)
   (MULTIPLE-VALUE-LIST
    (ROOTS-MULTI-EXAMPLE-NO-DERIVATIVE +BROYDEN+ NIL)))
  (LISP-UNIT::ASSERT-NUMERICAL-EQUAL
   (LIST 1.0d0 1.0d0 0.0d0 0.0d0)
   (MULTIPLE-VALUE-LIST
    (ROOTS-MULTI-EXAMPLE-DERIVATIVE +NEWTON-MFDFSOLVER+ NIL)))
  (LISP-UNIT::ASSERT-NUMERICAL-EQUAL
   (LIST 0.999999999999998d0 0.9999999999999964d0
	 1.9984014443252818d-15 4.440892098500626d-15)
   (MULTIPLE-VALUE-LIST
    (ROOTS-MULTI-EXAMPLE-DERIVATIVE +GNEWTON-MFDFSOLVER+ NIL)))
  (LISP-UNIT::ASSERT-NUMERICAL-EQUAL
   (LIST 1.0d0 1.0d0 0.0d0 0.0d0)
   (MULTIPLE-VALUE-LIST
    (ROOTS-MULTI-EXAMPLE-DERIVATIVE +POWELLS-HYBRID+ NIL)))
  (LISP-UNIT::ASSERT-NUMERICAL-EQUAL
   (LIST 0.9999999999999996d0 1.0000000000000568d0
	 4.440892098500626d-16 5.773159728050814d-13)
   (MULTIPLE-VALUE-LIST
    (ROOTS-MULTI-EXAMPLE-DERIVATIVE +POWELLS-HYBRID-UNSCALED+ NIL))))
