;; Regression test TDIST for GSLL
;;
;; Copyright 2009 Liam M. Healy
;; Distributed under the terms of the GNU General Public License
;;
;; This program is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or
;; (at your option) any later version.
;;
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with this program.  If not, see <http://www.gnu.org/licenses/>.

(in-package :gsl)

(lisp-unit:define-test tdist
  ;; From randist/test.c
  (lisp-unit::assert-true (testpdf (lambda (r) (tdist-pdf r 1.75d0)) :tdist :nu 1.75d0))
  (lisp-unit::assert-true (testpdf (lambda (r) (tdist-pdf r 12.75d0)) :tdist :nu 12.75d0))
  ;; From cdf/test.c
  (assert-to-tolerance (tdist-P 0.0d0 1.0d0) 0.5d0 +test-tol6+)
  (assert-to-tolerance (tdist-P 1d-100 1.0d0) 0.5d0 +test-tol6+)
  (assert-to-tolerance (tdist-P 0.001d0 1.0d0) 5.00318309780080559d-1 +test-tol6+)
  (assert-to-tolerance (tdist-P 0.01d0 1.0d0) 5.03182992764908255d-1 +test-tol6+)
  (assert-to-tolerance (tdist-P 0.1d0 1.0d0) 5.31725517430553569d-1 +test-tol6+)
  (assert-to-tolerance (tdist-P 0.325d0 1.0d0) 6.00023120032852123d-1 +test-tol6+)
  (assert-to-tolerance (tdist-P 1.0d0 1.0d0)  0.75000000000000000d0 +test-tol6+)
  (assert-to-tolerance (tdist-P 1.5d0 1.0d0) 8.12832958189001183d-1 +test-tol6+)
  (assert-to-tolerance (tdist-P 2.0d0 1.0d0) 8.52416382349566726d-1 +test-tol6+)
  (assert-to-tolerance (tdist-P 10.0d0 1.0d0) 9.68274482569446430d-1 +test-tol6+)
  (assert-to-tolerance (tdist-P 20.0d0 1.0d0) 9.84097748743823625d-1 +test-tol6+)
  (assert-to-tolerance (tdist-P 100.0d0 1.0d0) 9.96817007235091745d-1 +test-tol6+)
  (assert-to-tolerance (tdist-P 1000.0d0 1.0d0) 9.99681690219919441d-1 +test-tol6+)
  (assert-to-tolerance (tdist-P 10000.0d0 1.0d0) 9.99968169011487724d-1 +test-tol6+)

  (assert-to-tolerance (tdist-Q 0.0d0 1.0d0) 0.5d0 +test-tol6+)
  (assert-to-tolerance (tdist-Q 1d-100 1.0d0) 0.5d0 +test-tol6+)
  (assert-to-tolerance (tdist-Q 0.001d0 1.0d0) 4.99681690219919441d-1 +test-tol6+)
  (assert-to-tolerance (tdist-Q 0.01d0 1.0d0) 4.96817007235091745d-1 +test-tol6+)
  (assert-to-tolerance (tdist-Q 0.1d0 1.0d0) 4.68274482569446430d-1 +test-tol6+)
  (assert-to-tolerance (tdist-Q 0.325d0 1.0d0) 3.99976879967147876d-1 +test-tol6+)
  (assert-to-tolerance (tdist-Q 1.0d0 1.0d0) 2.5d-1 +test-tol6+)
  (assert-to-tolerance (tdist-Q 1.5d0 1.0d0) 1.87167041810998816d-1 +test-tol6+)
  (assert-to-tolerance (tdist-Q 2.0d0 1.0d0) 1.47583617650433274d-1 +test-tol6+)
  (assert-to-tolerance (tdist-Q 10.0d0 1.0d0) 3.17255174305535695d-2 +test-tol6+)
  (assert-to-tolerance (tdist-Q 20.0d0 1.0d0) 1.59022512561763752d-2 +test-tol6+)
  (assert-to-tolerance (tdist-Q 100.0d0 1.0d0) 3.18299276490825515d-3 +test-tol6+)
  (assert-to-tolerance (tdist-Q 1000.0d0 1.0d0) 3.18309780080558939d-4 +test-tol6+)
  (assert-to-tolerance (tdist-Q 10000.0d0 1.0d0) 3.18309885122757724d-5 +test-tol6+)

  (assert-to-tolerance (tdist-P -1.0d-100 1.0d0) 0.5d0 +test-tol6+)
  (assert-to-tolerance (tdist-P -0.001d0 1.0d0) 4.99681690219919441d-1 +test-tol6+)
  (assert-to-tolerance (tdist-P -0.01d0 1.0d0) 4.96817007235091744d-1 +test-tol6+)
  (assert-to-tolerance (tdist-P -0.1d0 1.0d0) 4.68274482569446430d-1 +test-tol6+)
  (assert-to-tolerance (tdist-P -0.325d0 1.0d0) 3.99976879967147876d-1 +test-tol6+)
  (assert-to-tolerance (tdist-P -1.0d0 1.0d0) 0.25d0 +test-tol6+)
  (assert-to-tolerance (tdist-P -1.5d0 1.0d0) 1.87167041810998816d-1 +test-tol6+)
  (assert-to-tolerance (tdist-P -2.0d0 1.0d0) 1.47583617650433274d-1 +test-tol6+)
  (assert-to-tolerance (tdist-P -10.0d0 1.0d0) 3.17255174305535695d-2 +test-tol6+)
  (assert-to-tolerance (tdist-P -20.0d0 1.0d0) 1.59022512561763751d-2 +test-tol6+)
  (assert-to-tolerance (tdist-P -100.0d0 1.0d0) 3.18299276490825514d-3 +test-tol6+)
  (assert-to-tolerance (tdist-P -1000.0d0 1.0d0) 3.18309780080558938d-4 +test-tol6+)
  (assert-to-tolerance (tdist-P -10000.0d0 1.0d0) 3.18309885122757724d-5 +test-tol6+)

  (assert-to-tolerance (tdist-Q -1.0d-100 1.0d0) 0.5d0 +test-tol6+)
  (assert-to-tolerance (tdist-Q -0.001d0 1.0d0) 5.00318309780080559d-1 +test-tol6+)
  (assert-to-tolerance (tdist-Q -0.01d0 1.0d0) 5.03182992764908255d-1 +test-tol6+)
  (assert-to-tolerance (tdist-Q -0.1d0 1.0d0) 5.31725517430553570d-1 +test-tol6+)
  (assert-to-tolerance (tdist-Q -0.325d0 1.0d0) 6.00023120032852124d-1 +test-tol6+)
  (assert-to-tolerance (tdist-Q -1.0d0 1.0d0) 7.5d-1 +test-tol6+)
  (assert-to-tolerance (tdist-Q -1.5d0 1.0d0) 8.12832958189001184d-1 +test-tol6+)
  (assert-to-tolerance (tdist-Q -2.0d0 1.0d0) 8.52416382349566726d-1 +test-tol6+)
  (assert-to-tolerance (tdist-Q -10.0d0 1.0d0) 9.68274482569446430d-1 +test-tol6+)
  (assert-to-tolerance (tdist-Q -20.0d0 1.0d0) 9.84097748743823625d-1 +test-tol6+)
  (assert-to-tolerance (tdist-Q -100.0d0 1.0d0) 9.96817007235091745d-1 +test-tol6+)
  (assert-to-tolerance (tdist-Q -1000.0d0 1.0d0) 9.99681690219919441d-1 +test-tol6+)
  (assert-to-tolerance (tdist-Q -10000.0d0 1.0d0) 9.99968169011487724d-1 +test-tol6+)

  (assert-to-tolerance (tdist-P 0.0d0 2.0d0) 0.5d0 +test-tol6+)
  (assert-to-tolerance (tdist-P 1d-100 2.0d0) 0.5d0 +test-tol6+)
  (assert-to-tolerance (tdist-P 0.001d0 2.0d0) 5.00353553302204959d-01 +test-tol6+)
  (assert-to-tolerance (tdist-P 0.01d0 2.0d0) 5.03535445520899514d-01 +test-tol6+)
  (assert-to-tolerance (tdist-P 0.1d0 2.0d0) 5.35267280792929913d-01 +test-tol6+)
  (assert-to-tolerance (tdist-P 0.325d0 2.0d0) 6.11985772746873767d-01 +test-tol6+)
  (assert-to-tolerance (tdist-P 1.0d0 2.0d0) 7.88675134594812882d-01 +test-tol6+)
  (assert-to-tolerance (tdist-P 1.5d0 2.0d0) 8.63803437554499460d-01 +test-tol6+)
  (assert-to-tolerance (tdist-P 2.0d0 2.0d0) 9.08248290463863016d-01 +test-tol6+)
  (assert-to-tolerance (tdist-P 10.0d0 2.0d0) 9.95073771488337154d-01 +test-tol6+)
  (assert-to-tolerance (tdist-P 20.0d0 2.0d0) 9.98754668053816452d-01 +test-tol6+)
  (assert-to-tolerance (tdist-P 100.0d0 2.0d0) 9.99950007498750219d-01 +test-tol6+)
  (assert-to-tolerance (tdist-P 1000.0d0 2.0d0) 9.99999500000749945d-01 +test-tol6+)
  (assert-to-tolerance (tdist-P 10000.0d0 2.0d0) 9.999999950000000739d-01 +test-tol6+)

  (assert-to-tolerance (tdist-Q 0.0d0 2.0d0) 0.5d0 +test-tol6+)
  (assert-to-tolerance (tdist-Q 1d-100 2.0d0) 0.5d0 +test-tol6+)
  (assert-to-tolerance (tdist-Q 0.001d0 2.0d0) 4.99646446697795041d-1 +test-tol6+)
  (assert-to-tolerance (tdist-Q 0.01d0 2.0d0) 4.96464554479100486d-1 +test-tol6+)
  (assert-to-tolerance (tdist-Q 0.1d0 2.0d0) 4.64732719207070087d-1 +test-tol6+)
  (assert-to-tolerance (tdist-Q 0.325d0 2.0d0) 3.88014227253126233d-1 +test-tol6+)
  (assert-to-tolerance (tdist-Q 1.0d0 2.0d0) 2.11324865405187118d-1 +test-tol6+)
  (assert-to-tolerance (tdist-Q 1.5d0 2.0d0) 1.36196562445500540d-1 +test-tol6+)
  (assert-to-tolerance (tdist-Q 2.0d0 2.0d0) 9.17517095361369836d-2 +test-tol6+)
  (assert-to-tolerance (tdist-Q 10.0d0 2.0d0) 4.92622851166284542d-3 +test-tol6+)
  (assert-to-tolerance (tdist-Q 20.0d0 2.0d0) 1.24533194618354849d-3 +test-tol6+)
  (assert-to-tolerance (tdist-Q 100.0d0 2.0d0) 4.99925012497812894d-5 +test-tol6+)
  (assert-to-tolerance (tdist-Q 1000.0d0 2.0d0) 4.99999250001249998d-7 +test-tol6+)
  (assert-to-tolerance (tdist-Q 10000.0d0 2.0d0) 4.99999992500000125d-9 +test-tol6+)

  (assert-to-tolerance (tdist-P -1.0d-100 2.0d0) 0.5d0 +test-tol6+)
  (assert-to-tolerance (tdist-P -0.001d0 2.0d0) 4.99646446697795041d-01 +test-tol6+)
  (assert-to-tolerance (tdist-P -0.01d0 2.0d0) 4.96464554479100486d-01 +test-tol6+)
  (assert-to-tolerance (tdist-P -0.1d0 2.0d0) 4.64732719207070087d-01 +test-tol6+)
  (assert-to-tolerance (tdist-P -0.325d0 2.0d0) 3.88014227253126233d-01 +test-tol6+)
  (assert-to-tolerance (tdist-P -1.0d0 2.0d0) 2.11324865405187118d-01 +test-tol6+)
  (assert-to-tolerance (tdist-P -1.5d0 2.0d0) 1.36196562445500540d-01 +test-tol6+)
  (assert-to-tolerance (tdist-P -2.0d0 2.0d0) 9.17517095361369836d-02 +test-tol6+)
  (assert-to-tolerance (tdist-P -10.0d0 2.0d0) 4.92622851166284542d-03 +test-tol6+)
  (assert-to-tolerance (tdist-P -20.0d0 2.0d0) 1.24533194618354849d-03 +test-tol6+)
  (assert-to-tolerance (tdist-P -100.0d0 2.0d0) 4.99925012497812894d-05 +test-tol6+)
  (assert-to-tolerance (tdist-P -1000.0d0 2.0d0) 4.99999250001249998d-07 +test-tol6+)
  (assert-to-tolerance (tdist-P -10000.0d0 2.0d0) 4.99999992500000125d-09 +test-tol6+)

  (assert-to-tolerance (tdist-Q -1.0d-100 2.0d0) 0.5d0 +test-tol6+)
  (assert-to-tolerance (tdist-Q -0.001d0 2.0d0) 5.00353553302204959d-1 +test-tol6+)
  (assert-to-tolerance (tdist-Q -0.01d0 2.0d0) 5.03535445520899514d-1 +test-tol6+)
  (assert-to-tolerance (tdist-Q -0.1d0 2.0d0) 5.35267280792929913d-1 +test-tol6+)
  (assert-to-tolerance (tdist-Q -0.325d0 2.0d0) 6.11985772746873767d-1 +test-tol6+)
  (assert-to-tolerance (tdist-Q -1.0d0 2.0d0) 7.88675134594812882d-1 +test-tol6+)
  (assert-to-tolerance (tdist-Q -1.5d0 2.0d0) 8.63803437554499460d-1 +test-tol6+)
  (assert-to-tolerance (tdist-Q -2.0d0 2.0d0) 9.08248290463863016d-1 +test-tol6+)
  (assert-to-tolerance (tdist-Q -10.0d0 2.0d0) 9.95073771488337155d-1 +test-tol6+)
  (assert-to-tolerance (tdist-Q -20.0d0 2.0d0) 9.98754668053816452d-1 +test-tol6+)
  (assert-to-tolerance (tdist-Q -100.0d0 2.0d0) 9.99950007498750219d-1 +test-tol6+)
  (assert-to-tolerance (tdist-Q -1000.0d0 2.0d0) 9.99999500000749999d-1 +test-tol6+)
  (assert-to-tolerance (tdist-Q -10000.0d0 2.0d0) 9.99999995000000075d-1 +test-tol6+)

  (assert-to-tolerance (tdist-P 0.0d0 300.0d0) 0.5d0 +test-tol6+)
  (assert-to-tolerance (tdist-P 1d-100 300.0d0) 0.5d0 +test-tol6+)
  (assert-to-tolerance (tdist-P 0.001d0 300.0d0) 5.00398609900942949d-01 +test-tol6+)
  (assert-to-tolerance (tdist-P 0.01d0 300.0d0) 5.03986033020559088d-01 +test-tol6+)
  (assert-to-tolerance (tdist-P 0.1d0 300.0d0) 5.39794441177768194d-01 +test-tol6+)
  (assert-to-tolerance (tdist-P 0.325d0 300.0d0) 6.27296201542523812d-01 +test-tol6+)
  (assert-to-tolerance (tdist-P 1.0d0 300.0d0) 8.40941797784686861d-01 +test-tol6+)
  (assert-to-tolerance (tdist-P 1.5d0 300.0d0) 9.32666983425369137d-01 +test-tol6+)
  (assert-to-tolerance (tdist-P 2.0d0 300.0d0) 9.76799239508425455d-01 +test-tol6+)
  (assert-to-tolerance (tdist-P 10.0d0 300.0d0) 1.0d0 +test-tol6+)
  (assert-to-tolerance (tdist-P 20.0d0 300.0d0) 1.0d0 +test-tol6+)
  (assert-to-tolerance (tdist-P 100.0d0 300.0d0) 1.0d0 +test-tol6+)
  (assert-to-tolerance (tdist-P 1000.0d0 300.0d0) 1.0d0 +test-tol6+)
  (assert-to-tolerance (tdist-P 10000.0d0 300.0d0) 1.0d0 +test-tol6+)

  (assert-to-tolerance (tdist-Q 0.0d0 300.0d0) 0.5d0 +test-tol6+)
  (assert-to-tolerance (tdist-Q 1d-100 300.0d0) 0.5d0 +test-tol6+)
  (assert-to-tolerance (tdist-Q 0.001d0 300.0d0) 4.99601390099057051d-1 +test-tol6+)
  (assert-to-tolerance (tdist-Q 0.01d0 300.0d0) 4.96013966979440912d-1 +test-tol6+)
  (assert-to-tolerance (tdist-Q 0.1d0 300.0d0) 4.60205558822231806d-1 +test-tol6+)
  (assert-to-tolerance (tdist-Q 0.325d0 300.0d0) 3.72703798457476188d-1 +test-tol6+)
  (assert-to-tolerance (tdist-Q 1.0d0 300.0d0) 1.59058202215313138d-1 +test-tol6+)
  (assert-to-tolerance (tdist-Q 1.5d0 300.0d0) 6.73330165746308628d-2 +test-tol6+)
  (assert-to-tolerance (tdist-Q 2.0d0 300.0d0) 2.32007604915745452d-2 +test-tol6+)
  (assert-to-tolerance (tdist-Q 10.0d0 300.0d0) 8.279313677d-21 +test-tol6+)
  (assert-to-tolerance (tdist-Q 20.0d0 300.0d0) 1.93159812815803978d-57 +test-tol6+)
  (assert-to-tolerance (tdist-Q 100.0d0 300.0d0) 1.02557519997736154d-232 +test-tol6+)
  (assert-to-tolerance (tdist-Q 1000.0d0 300.0d0) 0.0d0 +test-tol6+)
  (assert-to-tolerance (tdist-Q 10000.0d0 300.0d0) 0.0d0 +test-tol6+)

  (assert-to-tolerance (tdist-P -1.0d-100 300.0d0) 0.5d0 +test-tol6+)
  (assert-to-tolerance (tdist-P -0.001d0 300.0d0) 4.99601390099057051d-01 +test-tol6+)
  (assert-to-tolerance (tdist-P -0.01d0 300.0d0) 4.96013966979440912d-01 +test-tol6+)
  (assert-to-tolerance (tdist-P -0.1d0 300.0d0) 4.60205558822231806d-01 +test-tol6+)
  (assert-to-tolerance (tdist-P -0.325d0 300.0d0) 3.72703798457476188d-01 +test-tol6+)
  (assert-to-tolerance (tdist-P -1.0d0 300.0d0) 1.59058202215313138d-01 +test-tol6+)
  (assert-to-tolerance (tdist-P -1.5d0 300.0d0) 6.73330165746308628d-02 +test-tol6+)
  (assert-to-tolerance (tdist-P -2.0d0 300.0d0) 2.32007604915745452d-02 +test-tol6+)
  (assert-to-tolerance (tdist-P -10.0d0 300.0d0) 8.279313675556272534d-21 +test-tol6+)
  (assert-to-tolerance (tdist-P -20.0d0 300.0d0) 1.93159812815803978d-57 +test-tol6+)
  (assert-to-tolerance (tdist-P -100.0d0 300.0d0) 1.02557519997736154d-232 +test-tol6+)
  (assert-to-tolerance (tdist-P -1000.0d0 300.0d0) 0.0d0 +test-tol6+)
  (assert-to-tolerance (tdist-P -10000.0d0 300.0d0) 0.0d0 +test-tol6+)

  (assert-to-tolerance (tdist-Q -1.0d-100 300.0d0) 0.5d0 +test-tol6+)
  (assert-to-tolerance (tdist-Q -0.001d0 300.0d0) 5.00398609900942949d-1 +test-tol6+)
  (assert-to-tolerance (tdist-Q -0.01d0 300.0d0) 5.03986033020559088d-1 +test-tol6+)
  (assert-to-tolerance (tdist-Q -0.1d0 300.0d0) 5.39794441177768194d-1 +test-tol6+)
  (assert-to-tolerance (tdist-Q -0.325d0 300.0d0) 6.27296201542523812d-1 +test-tol6+)
  (assert-to-tolerance (tdist-Q -1.0d0 300.0d0) 8.40941797784686862d-1 +test-tol6+)
  (assert-to-tolerance (tdist-Q -1.5d0 300.0d0) 9.32666983425369137d-1 +test-tol6+)
  (assert-to-tolerance (tdist-Q -2.0d0 300.0d0) 9.76799239508425455d-1 +test-tol6+)
  (assert-to-tolerance (tdist-Q -10.0d0 300.0d0) 1.0d0 +test-tol6+)
  (assert-to-tolerance (tdist-Q -20.0d0 300.0d0) 1.0d0 +test-tol6+)
  (assert-to-tolerance (tdist-Q -100.0d0 300.0d0) 1.0d0 +test-tol6+)
  (assert-to-tolerance (tdist-Q -1000.0d0 300.0d0) 1.0d0 +test-tol6+)
  (assert-to-tolerance (tdist-Q -10000.0d0 300.0d0) 1.0d0 +test-tol6+)

  (assert-to-tolerance (tdist-Pinv 0.5d0 1.0d0) 0.0d0 +test-tol6+)
  (assert-to-tolerance (tdist-Pinv 5.00318309780080559d-1 1.0d0) 0.001d0 +test-tol6+)
  (assert-to-tolerance (tdist-Pinv 5.03182992764908255d-1 1.0d0) 0.01d0 +test-tol6+)
  (assert-to-tolerance (tdist-Pinv 5.31725517430553569d-1 1.0d0) 0.1d0 +test-tol6+)
  (assert-to-tolerance (tdist-Pinv 6.00023120032852123d-1 1.0d0) 0.325d0 +test-tol6+)
  (assert-to-tolerance (tdist-Pinv 0.75000000000000000d0 1.0d0) 1.0d0 +test-tol6+)
  (assert-to-tolerance (tdist-Pinv 8.12832958189001183d-1 1.0d0) 1.5d0 +test-tol6+)
  (assert-to-tolerance (tdist-Pinv 8.52416382349566726d-1 1.0d0)  2.0d0 +test-tol6+)
  (assert-to-tolerance (tdist-Pinv 9.68274482569446430d-1 1.0d0) 10.0d0 +test-tol6+)
  (assert-to-tolerance (tdist-Pinv 9.84097748743823625d-1 1.0d0) 20.0d0 +test-tol6+)
  (assert-to-tolerance (tdist-Pinv 9.96817007235091745d-1 1.0d0) 100.0d0 +test-tol6+)
  (assert-to-tolerance (tdist-Pinv 9.99681690219919441d-1 1.0d0) 1000.0d0 +test-tol6+)
  (assert-to-tolerance (tdist-Pinv 9.99968169011487724d-1 1.0d0) 10000.0d0 +test-tol6+)

  (assert-to-tolerance (tdist-Qinv 0.5d0 1.0d0) 0.0d0 +test-tol6+)
  (assert-to-tolerance (tdist-Qinv 4.99681690219919441d-1 1.0d0) 0.001d0 +test-tol6+)
  (assert-to-tolerance (tdist-Qinv 4.96817007235091745d-1 1.0d0) 0.01d0 +test-tol6+)
  (assert-to-tolerance (tdist-Qinv 4.68274482569446430d-1 1.0d0) 0.1d0 +test-tol6+)
  (assert-to-tolerance (tdist-Qinv 3.99976879967147876d-1 1.0d0) 0.325d0 +test-tol6+)
  (assert-to-tolerance (tdist-Qinv 2.5d-1 1.0d0) 1.0d0 +test-tol6+)
  (assert-to-tolerance (tdist-Qinv 1.87167041810998816d-1 1.0d0) 1.5d0 +test-tol6+)
  (assert-to-tolerance (tdist-Qinv 1.47583617650433274d-1 1.0d0) 2.0d0 +test-tol6+)
  (assert-to-tolerance (tdist-Qinv 3.17255174305535695d-2 1.0d0) 10.0d0 +test-tol6+)
  (assert-to-tolerance (tdist-Qinv 1.59022512561763752d-2 1.0d0) 20.0d0 +test-tol6+)
  (assert-to-tolerance (tdist-Qinv 3.18299276490825515d-3 1.0d0) 100.0d0 +test-tol6+)
  (assert-to-tolerance (tdist-Qinv 3.18309780080558939d-4 1.0d0) 1000.0d0 +test-tol6+)
  (assert-to-tolerance (tdist-Qinv 3.18309885122757724d-5 1.0d0) 10000.0d0 +test-tol6+)

  (assert-to-tolerance (tdist-Pinv 4.99681690219919441d-1 1.0d0) -0.001d0 +test-tol6+)
  (assert-to-tolerance (tdist-Pinv 4.96817007235091744d-1 1.0d0) -0.01d0 +test-tol6+)
  (assert-to-tolerance (tdist-Pinv 4.68274482569446430d-1 1.0d0) -0.1d0 +test-tol6+)
  (assert-to-tolerance (tdist-Pinv 3.99976879967147876d-1 1.0d0) -0.325d0 +test-tol6+)
  (assert-to-tolerance (tdist-Pinv 0.25d0 1.0d0) -1.0d0 +test-tol6+)
  (assert-to-tolerance (tdist-Pinv 1.87167041810998816d-1 1.0d0) -1.5d0 +test-tol6+)
  (assert-to-tolerance (tdist-Pinv 1.47583617650433274d-1 1.0d0) -2.0d0 +test-tol6+)
  (assert-to-tolerance (tdist-Pinv 3.17255174305535695d-2 1.0d0) -10.0d0 +test-tol6+)
  (assert-to-tolerance (tdist-Pinv 1.59022512561763751d-2 1.0d0) -20.0d0 +test-tol6+)
  (assert-to-tolerance (tdist-Pinv 3.18299276490825514d-3 1.0d0) -100.0d0 +test-tol6+)
  (assert-to-tolerance (tdist-Pinv 3.18309780080558938d-4 1.0d0) -1000.0d0 +test-tol6+)
  (assert-to-tolerance (tdist-Pinv 3.18309885122757724d-5 1.0d0) -10000.0d0 +test-tol6+)

  (assert-to-tolerance (tdist-Qinv 5.00318309780080559d-1 1.0d0) -0.001d0 +test-tol6+)
  (assert-to-tolerance (tdist-Qinv 5.03182992764908255d-1 1.0d0) -0.01d0 +test-tol6+)
  (assert-to-tolerance (tdist-Qinv 5.31725517430553570d-1 1.0d0) -0.1d0 +test-tol6+)
  (assert-to-tolerance (tdist-Qinv 6.00023120032852124d-1 1.0d0) -0.325d0 +test-tol6+)
  (assert-to-tolerance (tdist-Qinv 7.5d-1 1.0d0) -1.0d0 +test-tol6+)
  (assert-to-tolerance (tdist-Qinv 8.12832958189001184d-1 1.0d0) -1.5d0 +test-tol6+)
  (assert-to-tolerance (tdist-Qinv 8.52416382349566726d-1 1.0d0) -2.0d0 +test-tol6+)
  (assert-to-tolerance (tdist-Qinv 9.68274482569446430d-1 1.0d0) -10.0d0 +test-tol6+)
  (assert-to-tolerance (tdist-Qinv 9.84097748743823625d-1 1.0d0) -20.0d0 +test-tol6+)
  (assert-to-tolerance (tdist-Qinv 9.96817007235091745d-1 1.0d0) -100.0d0 +test-tol6+)
  (assert-to-tolerance (tdist-Qinv 9.99681690219919441d-1 1.0d0) -1000.0d0 +test-tol6+)
  (assert-to-tolerance (tdist-Qinv 9.99968169011487724d-1 1.0d0) -10000.0d0 +test-tol6+)

  (assert-to-tolerance (tdist-Pinv 4.99646446697795041d-01 2.0d0) -0.001d0 +test-tol6+)
  (assert-to-tolerance (tdist-Pinv 4.96464554479100486d-01 2.0d0) -0.01d0 +test-tol6+)
  (assert-to-tolerance (tdist-Pinv 4.64732719207070087d-01 2.0d0) -0.1d0 +test-tol6+)
  (assert-to-tolerance (tdist-Pinv 3.88014227253126233d-01 2.0d0) -0.325d0 +test-tol6+)
  (assert-to-tolerance (tdist-Pinv 2.11324865405187118d-01 2.0d0) -1.0d0 +test-tol6+)
  (assert-to-tolerance (tdist-Pinv 1.36196562445500540d-01 2.0d0) -1.5d0 +test-tol6+)
  (assert-to-tolerance (tdist-Pinv 9.17517095361369836d-02 2.0d0) -2.0d0 +test-tol6+)
  (assert-to-tolerance (tdist-Pinv 4.92622851166284542d-03 2.0d0) -10.0d0 +test-tol6+)
  (assert-to-tolerance (tdist-Pinv 1.24533194618354849d-03 2.0d0) -20.0d0 +test-tol6+)
  (assert-to-tolerance (tdist-Pinv 4.99925012497812894d-05 2.0d0) -100.0d0 +test-tol6+)
  (assert-to-tolerance (tdist-Pinv 4.99999250001249998d-07 2.0d0) -1000.0d0 +test-tol6+)
  (assert-to-tolerance (tdist-Pinv 4.99999992500000125d-09 2.0d0) -10000.0d0 +test-tol6+)

  (assert-to-tolerance (tdist-Qinv 5.00353553302204959d-1 2.0d0) -0.001d0 +test-tol6+)
  (assert-to-tolerance (tdist-Qinv 5.03535445520899514d-1 2.0d0) -0.01d0 +test-tol6+)
  (assert-to-tolerance (tdist-Qinv 5.35267280792929913d-1 2.0d0) -0.1d0 +test-tol6+)
  (assert-to-tolerance (tdist-Qinv 6.11985772746873767d-1 2.0d0) -0.325d0 +test-tol6+)
  (assert-to-tolerance (tdist-Qinv 7.88675134594812882d-1 2.0d0) -1.0d0 +test-tol6+)
  (assert-to-tolerance (tdist-Qinv 8.63803437554499460d-1 2.0d0) -1.5d0 +test-tol6+)
  (assert-to-tolerance (tdist-Qinv 9.08248290463863016d-1 2.0d0) -2.0d0 +test-tol6+)
  (assert-to-tolerance (tdist-Qinv 9.95073771488337155d-1 2.0d0) -10.0d0 +test-tol6+)
  (assert-to-tolerance (tdist-Qinv 9.98754668053816452d-1 2.0d0) -20.0d0 +test-tol6+)
  (assert-to-tolerance (tdist-Qinv 9.99950007498750219d-1 2.0d0) -100.0d0 +test-tol6+)
  (assert-to-tolerance (tdist-Qinv 9.99999500000749999d-1 2.0d0) -1000.0d0 +test-tol6+)
  (assert-to-tolerance (tdist-Qinv 9.99999995000000075d-1 2.0d0) -10000.0d0 1.0d-06)

  (assert-to-tolerance (tdist-Pinv 5.00000000000000000d-01 300.0d0) 0.0d0 +test-tol6+)
  (assert-to-tolerance (tdist-Pinv 5.00398609900942949d-01 300.0d0) 0.001d0 +test-tol6+)
  (assert-to-tolerance (tdist-Pinv 5.03986033020559088d-01 300.0d0) 0.01d0 +test-tol6+)
  (assert-to-tolerance (tdist-Pinv 5.39794441177768194d-01 300.0d0) 0.1d0 +test-tol6+)
  (assert-to-tolerance (tdist-Pinv 6.27296201542523812d-01 300.0d0) 0.325d0 +test-tol6+)
  (assert-to-tolerance (tdist-Pinv 8.40941797784686861d-01 300.0d0) 1.0d0 +test-tol6+)
  (assert-to-tolerance (tdist-Pinv 9.32666983425369137d-01 300.0d0) 1.5d0 +test-tol6+)
  (assert-to-tolerance (tdist-Pinv 9.76799239508425455d-01 300.0d0) 2.0d0 +test-tol6+)
  (assert-posinf (tdist-Pinv 1.0d0 300.0d0))

  (assert-to-tolerance (tdist-Qinv 5.00000000000000000d-01 300.0d0) 0.0d0 +test-tol6+)
  (assert-to-tolerance (tdist-Qinv 4.99601390099057051d-1 300.0d0) 0.001d0 +test-tol6+)
  (assert-to-tolerance (tdist-Qinv 4.96013966979440912d-1 300.0d0) 0.01d0 +test-tol6+)
  (assert-to-tolerance (tdist-Qinv 4.60205558822231806d-1 300.0d0) 0.1d0 +test-tol6+)
  (assert-to-tolerance (tdist-Qinv 3.72703798457476188d-1 300.0d0) 0.325d0 +test-tol6+)
  (assert-to-tolerance (tdist-Qinv 1.59058202215313138d-1 300.0d0) 1.0d0 +test-tol6+)
  (assert-to-tolerance (tdist-Qinv 6.73330165746308628d-2 300.0d0) 1.5d0 +test-tol6+)
  (assert-to-tolerance (tdist-Qinv 2.32007604915745452d-2 300.0d0) 2.0d0 +test-tol6+)
  (assert-to-tolerance (tdist-Qinv 8.279313677d-21 300.0d0) 10.0d0 +test-tol6+)
  (assert-to-tolerance (tdist-Qinv 1.93159812815803978d-57 300.0d0) 20.0d0 +test-tol6+)
  (assert-to-tolerance (tdist-Qinv 1.02557519997736154d-232 300.0d0) 100.0d0 +test-tol6+)
  (assert-posinf (tdist-Qinv 0.0d0 300.0d0))

  (assert-to-tolerance (tdist-Pinv 4.99601390099057051d-01 300.0d0) -0.001d0 +test-tol6+)
  (assert-to-tolerance (tdist-Pinv 4.96013966979440912d-01 300.0d0)  -0.01d0 +test-tol6+)
  (assert-to-tolerance (tdist-Pinv 4.60205558822231806d-01 300.0d0) -0.1d0 +test-tol6+)
  (assert-to-tolerance (tdist-Pinv 3.72703798457476188d-01 300.0d0) -0.325d0 +test-tol6+)
  (assert-to-tolerance (tdist-Pinv 1.59058202215313138d-01 300.0d0) -1.0d0 +test-tol6+)
  (assert-to-tolerance (tdist-Pinv 6.73330165746308628d-02 300.0d0) -1.5d0 +test-tol6+)
  (assert-to-tolerance (tdist-Pinv 2.32007604915745452d-02 300.0d0) -2.0d0 +test-tol6+)
  (assert-to-tolerance (tdist-Pinv 8.279313675556272534d-21 300.0d0) -10.0d0 +test-tol6+)
  (assert-to-tolerance (tdist-Pinv 1.93159812815803978d-57 300.0d0) -20.0d0 +test-tol6+)
  (assert-to-tolerance (tdist-Pinv 1.02557519997736154d-232 300.0d0) -100.0d0 +test-tol6+)
  (assert-neginf (tdist-Pinv 0.0d0 300.0d0))

  (assert-to-tolerance (tdist-Qinv 5.00398609900942949d-1 300.0d0) -0.001d0 +test-tol6+)
  (assert-to-tolerance (tdist-Qinv 5.03986033020559088d-1 300.0d0) -0.01d0 +test-tol6+)
  (assert-to-tolerance (tdist-Qinv 5.39794441177768194d-1 300.0d0) -0.1d0 +test-tol6+)
  (assert-to-tolerance (tdist-Qinv 6.27296201542523812d-1 300.0d0) -0.325d0 +test-tol6+)
  (assert-to-tolerance (tdist-Qinv 8.40941797784686862d-1 300.0d0) -1.0d0 +test-tol6+)
  (assert-to-tolerance (tdist-Qinv 9.32666983425369137d-1 300.0d0) -1.5d0 +test-tol6+)
  (assert-to-tolerance (tdist-Qinv 9.76799239508425455d-1 300.0d0) -2.0d0 +test-tol6+)
  (assert-neginf (tdist-Qinv 1.0d0 300.0d0))
  ;; Automatically converted from cdf/test_auto.c
  (ASSERT-TO-TOLERANCE (TDIST-P -1.d10 1.3d0) 3.46784811185d-14 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-PINV 3.4678481118500305d-14 1.3d0) -1.d10 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-P -1.d9 1.3d0) 6.91926665161d-13 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-PINV 6.919266651610352d-13 1.3d0) -1.d9 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-P -1.d8 1.3d0) 1.380575199718d-11 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-PINV 1.3805751997179027d-11 1.3d0) -1.d8 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-P -1.d7 1.3d0) 2.754609668978d-10 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-PINV 2.7546096689777484d-10 1.3d0) -1.d7 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-P -1000000.0d0 1.3d0) 5.496168864957d-9 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-PINV 5.496168864956998d-9 1.3d0) -1000000.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-P -100000.0d0 1.3d0) 1.096629861231d-7 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-PINV 1.0966298612314582d-7 1.3d0) -100000.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-P -10000.0d0 1.3d0) 2.188064222827d-6 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-PINV 2.1880642228271703d-6 1.3d0) -10000.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-P -1000.0d0 1.3d0) 4.365759541083d-5 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-PINV 4.365759541083357d-5 1.3d0) -1000.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-P -100.0d0 1.3d0) 8.710327647608d-4 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-PINV 8.71032764760792d-4 1.3d0) -100.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-P -10.0d0 1.3d0) 0.0172789338682d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-PINV 0.017278933868204446d0 1.3d0) -10.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-P -1.0d0 1.3d0) 0.2336211937932d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-PINV 0.23362119379322516d0 1.3d0) -1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-P -0.1d0 1.3d0) 0.4667575980083d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-PINV 0.4667575980082614d0 1.3d0) -0.1d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-P -0.01d0 1.3d0) 0.4966660755117d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-PINV 0.49666607551169606d0 1.3d0) -0.01d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-P -0.001d0 1.3d0) 0.4996665978189d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-PINV 0.4996665978188763d0 1.3d0) -0.001d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-P -1.d-4 1.3d0) 0.4999666597722d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-P -1.d-5 1.3d0) 0.4999966659772d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-P -1.d-6 1.3d0) 0.4999996665977d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-P -1.d-7 1.3d0) 0.4999999666598d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-P -1.d-8 1.3d0) 0.499999996666d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-P -1.d-9 1.3d0) 0.4999999996666d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-P -1.d-10 1.3d0) 0.4999999999667d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-P 0.0d0 1.3d0) 0.5d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-PINV 0.499999999999999d0 1.3d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-P 1.d-10 1.3d0) 0.5000000000333d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-P 1.d-9 1.3d0) 0.5000000003334d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-P 1.d-8 1.3d0) 0.500000003334d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-P 1.d-7 1.3d0) 0.5000000333402d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-P 1.d-6 1.3d0) 0.5000003334023d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-P 1.d-5 1.3d0) 0.5000033340228d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-P 1.d-4 1.3d0) 0.5000333402278d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-P 0.001d0 1.3d0) 0.5003334021811d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-PINV 0.5003334021811237d0 1.3d0) 0.001d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-P 0.01d0 1.3d0) 0.5033339244883d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-PINV 0.5033339244883039d0 1.3d0) 0.01d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-P 0.1d0 1.3d0) 0.5332424019917d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-PINV 0.5332424019917386d0 1.3d0) 0.1d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-P 1.0d0 1.3d0) 0.7663788062068d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-PINV 0.7663788062067749d0 1.3d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-P 10.0d0 1.3d0) 0.9827210661318d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-PINV 0.9827210661317956d0 1.3d0) 10.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-P 100.0d0 1.3d0) 0.9991289672352d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-PINV 0.9991289672352393d0 1.3d0) 100.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-P 1000.0d0 1.3d0) 0.9999563424046d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-P 10000.0d0 1.3d0) 0.9999978119358d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-P 100000.0d0 1.3d0) 0.999999890337d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-P 1000000.0d0 1.3d0) 0.9999999945038d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-P 1.d7 1.3d0) 0.9999999997245d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-P 1.d8 1.3d0) 0.9999999999862d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-P 1.d9 1.3d0) 0.9999999999993d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-P 1.d10 1.3d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-Q 1.d10 1.3d0) 3.46784811185d-14 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-QINV 3.4678481118500305d-14 1.3d0) 1.d10 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-Q 1.d9 1.3d0) 6.91926665161d-13 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-QINV 6.919266651610352d-13 1.3d0) 1.d9 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-Q 1.d8 1.3d0) 1.380575199718d-11 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-QINV 1.3805751997179027d-11 1.3d0) 1.d8 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-Q 1.d7 1.3d0) 2.754609668978d-10 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-QINV 2.7546096689777484d-10 1.3d0) 1.d7 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-Q 1000000.0d0 1.3d0) 5.496168864957d-9 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-QINV 5.496168864956998d-9 1.3d0) 1000000.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-Q 100000.0d0 1.3d0) 1.096629861231d-7 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-QINV 1.0966298612314582d-7 1.3d0) 100000.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-Q 10000.0d0 1.3d0) 2.188064222827d-6 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-QINV 2.1880642228271703d-6 1.3d0) 10000.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-Q 1000.0d0 1.3d0) 4.365759541083d-5 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-QINV 4.365759541083357d-5 1.3d0) 1000.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-Q 100.0d0 1.3d0) 8.710327647608d-4 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-QINV 8.71032764760792d-4 1.3d0) 100.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-Q 10.0d0 1.3d0) 0.0172789338682d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-QINV 0.017278933868204446d0 1.3d0) 10.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-Q 1.0d0 1.3d0) 0.2336211937932d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-QINV 0.23362119379322516d0 1.3d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-Q 0.1d0 1.3d0) 0.4667575980083d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-QINV 0.4667575980082614d0 1.3d0) 0.1d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-Q 0.01d0 1.3d0) 0.4966660755117d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-QINV 0.49666607551169606d0 1.3d0) 0.01d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-Q 0.001d0 1.3d0) 0.4996665978189d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-QINV 0.4996665978188763d0 1.3d0) 0.001d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-Q 1.d-4 1.3d0) 0.4999666597722d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-Q 1.d-5 1.3d0) 0.4999966659772d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-Q 1.d-6 1.3d0) 0.4999996665977d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-Q 1.d-7 1.3d0) 0.4999999666598d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-Q 1.d-8 1.3d0) 0.499999996666d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-Q 1.d-9 1.3d0) 0.4999999996666d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-Q 1.d-10 1.3d0) 0.4999999999667d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-Q 0.0d0 1.3d0) 0.5d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-QINV 0.499999999999999d0 1.3d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-Q -1.d-10 1.3d0) 0.5000000000333d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-Q -1.d-9 1.3d0) 0.5000000003334d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-Q -1.d-8 1.3d0) 0.500000003334d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-Q -1.d-7 1.3d0) 0.5000000333402d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-Q -1.d-6 1.3d0) 0.5000003334023d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-Q -1.d-5 1.3d0) 0.5000033340228d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-Q -1.d-4 1.3d0) 0.5000333402278d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-Q -0.001d0 1.3d0) 0.5003334021811d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-QINV 0.5003334021811237d0 1.3d0) -0.001d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-Q -0.01d0 1.3d0) 0.5033339244883d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-QINV 0.5033339244883039d0 1.3d0) -0.01d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-Q -0.1d0 1.3d0) 0.5332424019917d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-QINV 0.5332424019917386d0 1.3d0) -0.1d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-Q -1.0d0 1.3d0) 0.7663788062068d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-QINV 0.7663788062067749d0 1.3d0) -1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-Q -10.0d0 1.3d0) 0.9827210661318d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-QINV 0.9827210661317956d0 1.3d0) -10.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-Q -100.0d0 1.3d0) 0.9991289672352d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-QINV 0.9991289672352393d0 1.3d0) -100.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-Q -1000.0d0 1.3d0) 0.9999563424046d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-Q -10000.0d0 1.3d0) 0.9999978119358d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-Q -100000.0d0 1.3d0) 0.999999890337d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-Q -1000000.0d0 1.3d0) 0.9999999945038d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-Q -1.d7 1.3d0) 0.9999999997245d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-Q -1.d8 1.3d0) 0.9999999999862d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-Q -1.d9 1.3d0) 0.9999999999993d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (TDIST-Q -1.d10 1.3d0) 1.0d0 +TEST-TOL6+))
