;; Regression test WEIBULL for GSLL, automatically generated
;;
;; Copyright 2009 Liam M. Healy
;; Distributed under the terms of the GNU General Public License
;;
;; This program is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or
;; (at your option) any later version.
;;
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with this program.  If not, see <http://www.gnu.org/licenses/>.

(in-package :gsl)

(LISP-UNIT:DEFINE-TEST WEIBULL
  (LISP-UNIT::ASSERT-NUMERICAL-EQUAL
   (LIST
    (LIST 0.0160712303786595d0 1.347055359960668d0
	  1.1241262408795445d0 0.2329031397826649d0
	  1.209338423856536d0 0.8506825453443836d0
	  0.20845532973957762d0 0.5434187344070215d0
	  0.7849237503774361d0 0.5487883320132739d0
	  0.5239377808419179d0))
   (MULTIPLE-VALUE-LIST
    (LET ((RNG (MAKE-RANDOM-NUMBER-GENERATOR +MT19937+ 0)))
      (LOOP FOR I FROM 0 TO 10 COLLECT
	   (sample rng :weibull :a 1.0d0 :b 2.0d0)))))
  (LISP-UNIT::ASSERT-NUMERICAL-EQUAL
   (LIST 0.24263174972226745d0)
   (MULTIPLE-VALUE-LIST (WEIBULL-PDF 1.5d0 1.3d0 1.0d0)))
  ;; Automatically converted from cdf/test_auto.c
  (ASSERT-TO-TOLERANCE (WEIBULL-P 0.0d0 1.3d0 2.7d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (WEIBULL-P 1.d-10 1.3d0 2.7d0) 4.924395760785d-28 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (WEIBULL-PINV 4.92439576078527d-28 1.3d0 2.7d0) 1.d-10 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (WEIBULL-P 1.d-9 1.3d0 2.7d0) 2.468044288634d-25 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (WEIBULL-PINV 2.468044288633838d-25 1.3d0 2.7d0) 1.d-9 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (WEIBULL-P 1.d-8 1.3d0 2.7d0) 1.23695228949d-22 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (WEIBULL-PINV 1.2369522894899823d-22 1.3d0 2.7d0) 1.d-8 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (WEIBULL-P 1.d-7 1.3d0 2.7d0) 6.199446960984d-20 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (WEIBULL-PINV 6.199446960984052d-20 1.3d0 2.7d0) 1.d-7 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (WEIBULL-P 1.d-6 1.3d0 2.7d0) 3.107083672395d-17 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (WEIBULL-PINV 3.107083672394598d-17 1.3d0 2.7d0) 1.d-6 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (WEIBULL-P 1.d-5 1.3d0 2.7d0) 1.557230670416d-14 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (WEIBULL-PINV 1.557230670415903d-14 1.3d0 2.7d0) 1.d-5 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (WEIBULL-P 1.d-4 1.3d0 2.7d0) 7.804641318223d-12 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (WEIBULL-PINV 7.804641318222502d-12 1.3d0 2.7d0) 1.d-4 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (WEIBULL-P 0.001d0 1.3d0 2.7d0) 3.911586584098d-9 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (WEIBULL-PINV 3.9115865840980536d-9 1.3d0 2.7d0) 0.001d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (WEIBULL-P 0.01d0 1.3d0 2.7d0) 1.960435341356d-6 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (WEIBULL-PINV 1.9604353413559907d-6 1.3d0 2.7d0) 0.01d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (WEIBULL-P 0.1d0 1.3d0 2.7d0) 9.820635881537d-4 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (WEIBULL-PINV 9.82063588153714d-4 1.3d0 2.7d0) 0.1d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (WEIBULL-P 1.0d0 1.3d0 2.7d0) 0.3888663329609d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (WEIBULL-PINV 0.38886633296085954d0 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (WEIBULL-P 10.0d0 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (WEIBULL-P 100.0d0 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (WEIBULL-P 1000.0d0 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (WEIBULL-P 10000.0d0 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (WEIBULL-P 100000.0d0 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (WEIBULL-P 1000000.0d0 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (WEIBULL-P 1.d7 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (WEIBULL-P 1.d8 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (WEIBULL-P 1.d9 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (WEIBULL-P 1.d10 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (WEIBULL-Q 1.d10 1.3d0 2.7d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (WEIBULL-Q 1.d9 1.3d0 2.7d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (WEIBULL-Q 1.d8 1.3d0 2.7d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (WEIBULL-Q 1.d7 1.3d0 2.7d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (WEIBULL-Q 1000000.0d0 1.3d0 2.7d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (WEIBULL-Q 100000.0d0 1.3d0 2.7d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (WEIBULL-Q 10000.0d0 1.3d0 2.7d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (WEIBULL-Q 1000.0d0 1.3d0 2.7d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (WEIBULL-Q 100.0d0 1.3d0 2.7d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (WEIBULL-Q 10.0d0 1.3d0 2.7d0) 6.51926200407d-108 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (WEIBULL-QINV 6.519262004069862d-108 1.3d0 2.7d0) 10.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (WEIBULL-Q 1.0d0 1.3d0 2.7d0) 0.6111336670391d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (WEIBULL-QINV 0.6111336670391404d0 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (WEIBULL-Q 0.1d0 1.3d0 2.7d0) 0.9990179364118d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (WEIBULL-QINV 0.9990179364118463d0 1.3d0 2.7d0) 0.1d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (WEIBULL-Q 0.01d0 1.3d0 2.7d0) 0.9999980395647d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (WEIBULL-Q 0.001d0 1.3d0 2.7d0) 0.9999999960884d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (WEIBULL-Q 1.d-4 1.3d0 2.7d0) 0.9999999999922d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (WEIBULL-Q 1.d-5 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (WEIBULL-Q 1.d-6 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (WEIBULL-Q 1.d-7 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (WEIBULL-Q 1.d-8 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (WEIBULL-Q 1.d-9 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (WEIBULL-Q 1.d-10 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (WEIBULL-Q 0.0d0 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+))

